/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.utils;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.PathUtils;
import filenet.vw.base.RetryManager;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertTwo;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.listener.utils.Constants;
import filenet.ws.listener.utils.VWSessionManager;
import filenet.ws.utils.WSLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

public class WSListenerProperties
extends Properties {
    private static final long serialVersionUID = 7460L;
    protected static String HOSTNAME = "localhost";
    private static final int KEY_MASK = 0;
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.utils.properties");
    protected static Logger ioLogger = Logger.getLogger("filenet.ws.listener.utils.properties.io");
    private static final String m_className = "WSListenerProperties";
    private static int LOCK_TIMEOUT = 60000;
    private String m_routerPath = null;
    private String m_fullPath = null;
    private String m_lockFilePath = null;
    private transient String m_name = null;
    private transient String m_pw = null;
    private transient String m_keystorePw = null;
    private transient String m_truststorePw = null;
    private transient String m_instantiator = null;
    private File m_File = null;
    private File m_lockFile = null;
    private String STANZA = null;
    private String thisClassName = WSListenerProperties.class.getName();
    private static String[] JSSEPropertyNames;
    private static String WSLoggerFileName;
    private static SimpleDateFormat dateFormat;
    private long lastModified = 0L;
    private static String WSRM_WSRMPOLICY_XML_CONTENTS_TEMPLATE;
    private static String WSRM_SANDESHA_PROPERTIES_CONTENTS_TEMPLATE;
    private static String[] WSRMPropertyNames;
    private static boolean verbose;

    public static String _get_FILE_DATE() {
        return "$Date:   03 Apr 2009 17:59:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.54  $";
    }

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private String getCaller() {
        StringBuffer buf = new StringBuffer("[tid=" + Thread.currentThread().getName() + ", stack=");
        Exception ex = new Exception();
        StackTraceElement[] stacks = ex.getStackTrace();
        int len = stacks == null ? 0 : stacks.length;
        for (int i = 0; i < len; ++i) {
            buf.append(stacks[i]);
            if (i >= len - 1) continue;
            buf.append(", at ");
        }
        return buf.append("]").toString();
    }

    private WSListenerProperties(String searchPath, String cpName) throws VWException {
        if (searchPath == null) {
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.NullFileName", "Null file name was given.");
        }
        this.m_instantiator = this.getCaller();
        this.m_fullPath = searchPath;
        this.m_lockFilePath = this.m_fullPath + ".PE.LOCK";
        this.m_File = new File(this.m_fullPath);
        if (!this.m_File.exists() || this.m_File.isDirectory()) {
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.FileNotFound", "{0} is not found.", this.m_fullPath);
        }
        this.STANZA = cpName;
        this.m_routerPath = this.m_File.getParent();
        this.refresh();
        if (this.STANZA == null) {
            this.STANZA = this.getDefaultStanza();
        }
        this.m_lockFile = new File(this.m_lockFilePath);
        if (logger.isFinest()) {
            logger.finest("FILE = " + this.m_fullPath);
        }
    }

    public void setStanza(String stanza) {
        if (stanza == null) {
            stanza = this.getDefaultStanza();
        }
        this.STANZA = stanza;
    }

    public String getStanza() {
        return this.STANZA;
    }

    private String getDefaultStanza() {
        return super.getProperty("cm.router");
    }

    public String getStore(String s) {
        if (s == null || s.trim().length() == 0) {
            return System.getProperty("java.home") + "/lib/security/cacerts";
        }
        return s;
    }

    public void setJSSEOptions(String keystoreFile, String keystorePw, String truststoreFile, String truststorePw, boolean autoAccept) {
        this.setProperties(JSSEPropertyNames, new String[]{keystoreFile, keystorePw, truststoreFile, truststorePw, new Boolean(autoAccept).toString()}, true);
    }

    public String getKeystoreFile() {
        return this.getStore(this.getProperty("cm.keystore"));
    }

    public String getKeystorePassword() throws VWException {
        this.adjustKeystoreCreds();
        return this.m_keystorePw;
    }

    public String getTruststorePassword() throws VWException {
        this.adjustTrustStoreCreds();
        return this.m_truststorePw;
    }

    private boolean isDefaultStanza(String stanza) {
        String defaultStanza = this.getDefaultStanza();
        return defaultStanza == null ? false : defaultStanza.equals(stanza);
    }

    public void cleanupStanza(String stanza) {
        if (stanza == null) {
            return;
        }
        try {
            this.refresh();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean isDefaultStanza = false;
        isDefaultStanza = this.isDefaultStanza(stanza);
        if (this.STANZA != null && this.STANZA.equals(stanza)) {
            this.STANZA = null;
        }
        Enumeration<Object> e = this.keys();
        Vector<String> removedProps = new Vector<String>();
        stanza = "." + stanza;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.endsWith(stanza)) continue;
            removedProps.add(key);
        }
        if (isDefaultStanza) {
            removedProps.add("cm.router");
        }
        try {
            this.save(null, removedProps);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (isDefaultStanza) {
            int numStanzas;
            String[] stanzas = this.getStanzas();
            int n = numStanzas = stanzas == null ? 0 : stanzas.length;
            if (numStanzas > 0) {
                this.duplicateStanza(this.getNonEmptyStanza(stanzas), null);
            }
        }
    }

    private String getNonEmptyStanza(String[] stanzas) {
        int nStanzas = stanzas == null ? 0 : stanzas.length;
        for (int i = 0; i < nStanzas; ++i) {
            if (stanzas[i] == null || stanzas[i].trim().length() <= 0) continue;
            return stanzas[i].trim();
        }
        return null;
    }

    public void duplicateStanza(String _srcStanza, String dstStanza) {
        String m_method = "duplicateStanza:" + _srcStanza + "," + dstStanza;
        if (_srcStanza == null) {
            return;
        }
        logger.entering(m_className, m_method);
        Properties modifiedProperties = new Properties();
        Enumeration<Object> e = this.keys();
        String srcStanza = "." + _srcStanza;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.endsWith(srcStanza)) continue;
            int index = key.lastIndexOf(srcStanza);
            String newKey = key.substring(0, index);
            if (dstStanza != null) {
                newKey = newKey + "." + dstStanza;
            }
            modifiedProperties.setProperty(newKey, super.getProperty(key));
        }
        modifiedProperties.setProperty("cm.router" + (dstStanza == null ? "" : "." + dstStanza), dstStanza == null ? _srcStanza : dstStanza);
        try {
            this.save(modifiedProperties, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        logger.exiting(m_className, m_method);
    }

    public void renameStanza(String oldStanza, String newStanza) {
        if (oldStanza == null || newStanza == null) {
            return;
        }
        Properties modifiedProperties = new Properties();
        Vector<String> removedProps = new Vector<String>();
        if (this.isDefaultStanza(oldStanza)) {
            modifiedProperties.setProperty("cm.router", newStanza);
        }
        Enumeration<Object> e = this.keys();
        oldStanza = "." + oldStanza;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.endsWith(oldStanza)) continue;
            String value = (String)this.remove(key);
            removedProps.add(key);
            int index = key.lastIndexOf(oldStanza);
            String newKey = key.substring(0, index) + "." + newStanza;
            modifiedProperties.setProperty(newKey, value);
        }
        try {
            this.save(modifiedProperties, removedProps);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public String getTruststoreFile() {
        return this.getStore(this.getProperty("cm.truststore"));
    }

    public boolean getCertificatesAutoAccept() {
        boolean res = false;
        String s = this.getProperty("cm.certificates.autoaccept", null);
        if (s != null) {
            try {
                res = new Boolean(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res;
    }

    public String getProperty(String name, String def) {
        String value = this.getStanzaProperty(name, true);
        if (value == null) {
            value = def;
        }
        return value;
    }

    protected String getStanzaProperty(String name, boolean refreshIt) {
        if (refreshIt) {
            try {
                this.refresh();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        String m_method = "getStanzaProperty:" + name;
        String propName = this.formStanzaPropertyName(name);
        String value = super.getProperty(propName);
        if (value == null && this.STANZA != null) {
            propName = name;
            value = super.getProperty(name);
        }
        return value;
    }

    private String formStanzaPropertyName(String name) {
        String res = name + (this.STANZA == null ? "" : "." + this.STANZA);
        return res;
    }

    private String getStanzaPropertyOnly(String name) {
        try {
            this.refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.getProperty(this.formStanzaPropertyName(name));
    }

    public String getProperty(String name) {
        return this.getStanzaProperty(name, true);
    }

    public String getPropertyNoStanza(String name, String defaultValue) {
        try {
            this.refresh();
        }
        catch (Throwable t) {
            // empty catch block
        }
        String val = super.getProperty(name);
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public void checkUniqueProperty(String name, String value) throws VWException {
        this.refresh();
        String myKey = this.formStanzaPropertyName(name);
        String[] keys = this.getStanzaKeysForAPrefix(name);
        int nKeys = keys == null ? 0 : keys.length;
        for (int i = 0; i < nKeys; ++i) {
            String v;
            if (myKey.equals(keys[i]) || keys[i].equals(name) || !value.equals(v = super.getProperty(keys[i]))) continue;
            VWException vwe = new VWException("ws.listener.notUniqueProperty", "The given value {0} is not unique for {1} of {2}.  Please choose a unique value for this property.", new Object[]{value, name, this.STANZA});
            throw vwe;
        }
    }

    public String[] getProperties(String[] names) {
        int nProps;
        int n = nProps = names == null ? 0 : names.length;
        if (nProps == 0) {
            return null;
        }
        try {
            this.refresh();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] res = new String[nProps];
        for (int i = 0; i < nProps; ++i) {
            res[i] = this.getStanzaProperty(names[i], false);
        }
        return res;
    }

    public synchronized void setProperties(String[] names, String[] values, boolean needRefresh) {
        if (names == null || values == null || names.length != values.length) {
            return;
        }
        Properties modifiedProperties = new Properties();
        Vector<String> removedProps = new Vector<String>();
        int nItems = names.length;
        for (int i = 0; i < nItems; ++i) {
            String name = names[i];
            String value = values[i];
            String newName = this.formStanzaPropertyName(name);
            if (value == null || value.trim().length() == 0) {
                removedProps.add(newName);
            }
            value = value.trim();
            if (super.getProperty(name) == null && this.STANZA != null) {
                modifiedProperties.setProperty(name, value);
            }
            String defStanza = this.getDefaultStanza();
            if (this.STANZA != null && defStanza != null && this.STANZA.equals(defStanza)) {
                modifiedProperties.setProperty(name, value);
            }
            modifiedProperties.setProperty(newName, value);
        }
        try {
            this.save(modifiedProperties, removedProps);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public synchronized Object setProperty(String name, String value) {
        String newName = this.formStanzaPropertyName(name);
        try {
            String defStanza;
            if (value == null || value.trim().length() == 0) {
                Vector<String> removedProps = new Vector<String>();
                removedProps.add(newName);
                this.save(null, removedProps);
                return null;
            }
            value = value.trim();
            Properties modifiedProperties = new Properties();
            if (super.getProperty(name) == null && this.STANZA != null) {
                modifiedProperties.setProperty(name, value);
            }
            if ((defStanza = this.getDefaultStanza()) == null || this.STANZA != null && defStanza != null && this.STANZA.equals(defStanza)) {
                modifiedProperties.setProperty(name, value);
            }
            Object obj = super.setProperty(newName, value);
            modifiedProperties.setProperty(newName, value);
            this.save(modifiedProperties, null);
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setOption(String propName, String defaultVal, Vector vNames, Vector vValues) {
        String val = this.getStanzaProperty(propName, false);
        val = System.getProperty(propName, val == null ? defaultVal : val);
        vNames.add(propName);
        vValues.add(val);
    }

    private void setOptions() {
        try {
            if (super.getProperty("last.updated") != null && super.getProperty("filenet.wsrm.client.listener.port") != null) {
                return;
            }
            Vector vNames = new Vector();
            Vector vValues = new Vector();
            this.setOption("filenet.ws.listener.tracing", "false", vNames, vValues);
            this.setOption("filenet.ws.listener.tracefilesize", "5000000", vNames, vValues);
            this.setOption("filenet.ws.request.tracing", "false", vNames, vValues);
            this.setOption("filenet.ws.request.tracefilesize", "5000000", vNames, vValues);
            this.setOption("filenet.ws.request.cache.timeout", "4", vNames, vValues);
            this.setOption("filenet.ws.listener.cache.timeout", "4", vNames, vValues);
            this.setOption("filenet.wsrm.client.listener.host", "localhost", vNames, vValues);
            this.setOption("filenet.wsrm.client.listener.port", Constants.LISTENER_PROPERTY_WSRM_CLIENT_LISTENER_PORT_DEFAULT_STR, vNames, vValues);
            this.setOption("filenet.wsrm.inactivity.timeout", "600000", vNames, vValues);
            this.setOption("filenet.wsrm.base.retransmission.interval", "3000", vNames, vValues);
            this.setOption("filenet.wsrm.acknowledgement.interval", "200", vNames, vValues);
            this.setOption("filenet.ws.request.tracefile", WSLoggerFileName, vNames, vValues);
            this.setOption("filenet.ws.listener.tracefile", WSLoggerFileName, vNames, vValues);
            this.setOption("att.handler", "filenet.vw.idm.trident.WSSession", vNames, vValues);
            this.setProperties(vNames.toArray(new String[0]), vValues.toArray(new String[0]), false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void adjustProperties() throws VWException {
        String m_method = "adjustProperties";
        this.setOptions();
    }

    private void adjustKeystoreCreds() throws VWException {
        block6: {
            String m_method = "adjustKeystoreCreds";
            this.refresh();
            this.m_keystorePw = this.getStanzaProperty("cm.keystore.uid", false);
            if (this.m_keystorePw != null) {
                try {
                    VWCMConvertTwo converter = new VWCMConvertTwo(0);
                    VWAuthItem item = converter.getDString(this.m_keystorePw);
                    if (item != null) {
                        this.m_keystorePw = item.getPassword();
                        if (this.m_keystorePw != null && this.m_keystorePw.compareTo("\"\"") == 0) {
                            this.m_keystorePw = "";
                        }
                        break block6;
                    }
                    VWException vwe = new VWException("vw.integrator.base.VWCMInvalidKeystorePassword", "Keystore password is invalid.");
                    logger.throwing(m_className, "adjustKeystoreCreds", vwe);
                    throw vwe;
                }
                catch (VWException vwex) {
                    throw vwex;
                }
                catch (Exception e) {
                    logger.throwing(m_className, "adjustKeystoreCreds", e);
                    throw new VWException(e);
                }
            }
        }
    }

    private void adjustTrustStoreCreds() throws VWException {
        block6: {
            String m_method = "adjustTrustStoreCreds";
            this.refresh();
            this.m_truststorePw = this.getStanzaProperty("cm.truststore.uid", false);
            if (this.m_truststorePw != null) {
                try {
                    VWCMConvertTwo converter = new VWCMConvertTwo(0);
                    VWAuthItem item = converter.getDString(this.m_truststorePw);
                    if (item != null) {
                        this.m_truststorePw = item.getPassword();
                        if (this.m_truststorePw != null && this.m_truststorePw.compareTo("\"\"") == 0) {
                            this.m_truststorePw = "";
                        }
                        break block6;
                    }
                    VWException vwe = new VWException("vw.integrator.base.VWCMTruststorePassword", "Truststore password is invalid.");
                    logger.throwing(m_className, "adjustTrustStoreCreds", vwe);
                    throw vwe;
                }
                catch (VWException vwex) {
                    throw vwex;
                }
                catch (Exception e) {
                    logger.throwing(m_className, "adjustTrustStoreCreds", e);
                    throw new VWException(e);
                }
            }
        }
    }

    public static String getRealPathWithDefault(InputStream inStream, boolean checkExistence, String defaultFileName) throws VWException {
        String s = WSListenerProperties.getRealPath(inStream, checkExistence);
        if (s != null && s.equals("self")) {
            s = defaultFileName;
        }
        return s;
    }

    public static String getRealPath(InputStream inStream, boolean checkExistence) throws VWException {
        String m_method = "getRealPath";
        if (inStream == null) {
            return null;
        }
        Properties routerProps = new Properties();
        RetryManager retryIt = new RetryManager(LOCK_TIMEOUT);
        do {
            try {
                routerProps.load(inStream);
                retryIt.stop();
            }
            catch (Throwable t) {
                if (!(t instanceof IOException) || t.getMessage().indexOf("lock") != -1) {
                    // empty if block
                }
                retryIt.setCauseObj(t);
            }
        } while (retryIt.again());
        if (!retryIt.getStatus()) {
            Object cause = retryIt.getCauseObj();
            if (cause instanceof Throwable) {
                throw new VWException((Throwable)cause);
            }
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.readTimeout", "Read timeout for P8BPMWSBroker.properties file.  Error={0}", retryIt.toString());
        }
        String routerPath = routerProps.getProperty("router.path");
        if (routerPath == null) {
            if (ioLogger.isFinest()) {
                ioLogger.finest(m_className, m_method, "Missing Router Path!: " + WSListenerProperties.getPPProperties(routerProps));
            }
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.noRouterPath", "Missing {0} property", "router.path");
        }
        if (routerPath.trim().equalsIgnoreCase("self")) {
            return routerPath.trim().toLowerCase();
        }
        File f = new File(routerPath);
        if (!f.exists() || !f.isDirectory()) {
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.InvalidDirectory", "{0} is not a valid directory.", routerPath);
        }
        String routerFullPath = routerPath + File.separator + "P8BPMWSBroker.properties";
        if (checkExistence && !(f = new File(routerFullPath)).exists()) {
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.FileNotFound", "{0} is not found.", routerFullPath);
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, routerFullPath);
        }
        return routerFullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static String getPath(PathUtils searchPath, boolean checkExistence) throws VWException {
        InputStream inStream = null;
        String m_method = "getPath";
        try {
            String dir = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.ws.listener.properties.location");
            if (dir != null) {
                if (searchPath == null) {
                    searchPath = new PathUtils();
                }
                searchPath.addPath(dir);
            }
            try {
                inStream = searchPath == null ? ClassLoader.getSystemResourceAsStream("P8BPMWSBroker.properties") : searchPath.getResourceAsStreamFromDirectory("P8BPMWSBroker.properties");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (inStream != null) {
                String string;
                try {
                    string = WSListenerProperties.getRealPath(inStream, checkExistence);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {
                        inStream.close();
                        inStream = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inStream.close();
                    inStream = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return string;
            }
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.FileNotFoundInSearchPath", "{0} is not found in search path.", "P8BPMWSBroker.properties");
        }
        catch (VWException vwe) {
            logger.throwing(m_className, "getPath", vwe);
            throw vwe;
        }
        catch (Exception e) {
            logger.throwing(m_className, "getPath", e);
            throw new VWException(e);
        }
    }

    private static boolean validateRouterPath(Properties p, String loc) {
        String m_method = "validateRouterPath";
        String routerPath = p.getProperty("router.path");
        if (routerPath == null || !new File(routerPath).exists() || !new File(routerPath).isDirectory()) {
            Exception t = new Exception(loc + ":>> INVALID ROUTER.PATH either missing or invalid:" + routerPath);
            if (ioLogger.isFinest()) {
                ioLogger.throwing(m_className, "validateRouterPath", t);
            }
            return false;
        }
        if (ioLogger.isFinest()) {
            ioLogger.finest(m_className, "validateRouterPath", loc + ": IS OK..");
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private void save(Properties modifiedProperties, Vector removedProps) throws VWException {
        block28: {
            Exception ex2222;
            ByteBuffer byteBuffer;
            byte[] outBuf;
            byte[] bArr;
            FileLock fl;
            AbstractInterruptibleChannel fc;
            RandomAccessFile outStream;
            block25: {
                outStream = null;
                String m_method = "save";
                if (!(modifiedProperties != null && modifiedProperties.size() != 0 || removedProps != null && removedProps.size() != 0)) {
                    return;
                }
                Properties pFinalVersion = new Properties();
                fc = null;
                fl = null;
                bArr = null;
                outBuf = null;
                byteBuffer = null;
                outStream = new RandomAccessFile(this.m_fullPath, "rws");
                fc = outStream.getChannel();
                fl = this.lockFile((FileChannel)fc);
                long lastFileSize = ((FileChannel)fc).size();
                byteBuffer = ByteBuffer.allocate((int)lastFileSize);
                ((FileChannel)fc).read(byteBuffer);
                bArr = byteBuffer.array();
                ByteArrayInputStream bInStream = new ByteArrayInputStream(bArr);
                pFinalVersion.load(bInStream);
                WSListenerProperties.validateRouterPath(pFinalVersion, "PRESAVE");
                if (modifiedProperties != null) {
                    pFinalVersion.putAll((Map<?, ?>)modifiedProperties);
                }
                if (removedProps != null) {
                    Iterator iter = removedProps.iterator();
                    while (iter.hasNext()) {
                        pFinalVersion.remove(iter.next());
                    }
                }
                String updateInfo = dateFormat.format(new Date()) + " at " + this.getCaller() + ", object created by " + this.m_instantiator;
                pFinalVersion.setProperty("last.updated", updateInfo);
                WSListenerProperties.validateRouterPath(pFinalVersion, "DURINGSAVE");
                String savedFormat = WSListenerProperties.getPPProperties(pFinalVersion);
                ((FileChannel)fc).position(0L);
                outBuf = savedFormat.getBytes("UTF-8");
                ((FileChannel)fc).write(ByteBuffer.wrap(outBuf));
                lastFileSize = ((FileChannel)fc).position();
                int idealSize = outBuf.length;
                if (lastFileSize != (long)idealSize && ioLogger.isFinest()) {
                    ioLogger.severe(m_className, "save", "ERROR--fileSize=" + lastFileSize + ", should be " + idealSize);
                }
                ((FileChannel)fc).truncate(lastFileSize);
                fc.close();
                fc = null;
                outStream.close();
                outStream = null;
                this.unlockFile(fl);
                fl = null;
                this.lastModified = this.m_File.lastModified();
                this.clear();
                this.putAll((Map<?, ?>)pFinalVersion);
                WSListenerProperties.validateRouterPath(this, "POSTSAVE");
                Object var18_17 = null;
                if (fc == null) break block25;
                try {
                    fc.close();
                }
                catch (Exception ex2222) {
                    // empty catch block
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception ex2222) {
                    // empty catch block
                }
            }
            if (fl != null) {
                try {
                    this.unlockFile(fl);
                }
                catch (Exception ex2222) {
                    // empty catch block
                }
            }
            bArr = null;
            outBuf = null;
            if (byteBuffer != null) {
                byteBuffer.clear();
                byteBuffer = null;
            }
            break block28;
            {
                catch (Throwable e) {
                    logger.throwing(m_className, "save", e);
                    throw new VWException(e);
                }
            }
            catch (Throwable throwable) {
                Exception ex2222;
                Object var18_18 = null;
                if (fc != null) {
                    try {
                        fc.close();
                    }
                    catch (Exception ex2222) {
                        // empty catch block
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception ex2222) {
                        // empty catch block
                    }
                }
                if (fl != null) {
                    try {
                        this.unlockFile(fl);
                    }
                    catch (Exception ex2222) {
                        // empty catch block
                    }
                }
                bArr = null;
                outBuf = null;
                if (byteBuffer != null) {
                    byteBuffer.clear();
                    byteBuffer = null;
                }
                throw throwable;
            }
        }
    }

    private FileLock lockFile(FileChannel fc) throws IOException, VWException, InterruptedException {
        String m_method = "lockFile";
        long startTime = System.currentTimeMillis();
        long curTime = 0L;
        FileLock fl = null;
        while (fl == null) {
            try {
                fl = fc.lock();
                this.createLockFile();
            }
            catch (OverlappingFileLockException ex) {
                curTime = System.currentTimeMillis();
                if (curTime - startTime > 300000L) {
                    VWException t = new VWException("ws.listener.propertyFileLockedTooLong", "The file {0} has been locked for a long time.  Saving not complete.", this.m_fullPath);
                    ioLogger.throwing(m_className, "lockFile", t);
                    throw t;
                }
                Thread.sleep(20L);
            }
        }
        curTime = System.currentTimeMillis();
        long elapsed = curTime - startTime;
        if (ioLogger.isFinest() && elapsed > 1000L) {
            ioLogger.finest(m_className, "lockFile", "Waited " + elapsed + "ms");
        }
        return fl;
    }

    private void createLockFile() {
        try {
            this.m_lockFile.createNewFile();
            this.m_lockFile.deleteOnExit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unlockFile(FileLock fl) {
        block4: {
            try {
                if (fl != null) {
                    fl.release();
                }
                if (this.m_lockFile.exists()) {
                    this.m_lockFile.delete();
                }
            }
            catch (Exception e) {
                if (!ioLogger.isFinest()) break block4;
                ioLogger.throwing(m_className, "unlockFile", e);
            }
        }
    }

    public synchronized void refresh() throws VWException {
        Properties p = this.readFromFile();
        if (p != null && p.size() == 0 && ioLogger.isFinest()) {
            ioLogger.throwing(m_className, "refresh", new Exception("FAILED to READ!"));
        }
        if (p == null) {
            return;
        }
        this.clear();
        this.putAll((Map<?, ?>)p);
        this.adjustProperties();
    }

    public synchronized VWSession getVWSession() throws VWException {
        return this.getVWSession(null);
    }

    protected String checkDefaultCPName(String cpName) throws VWException {
        String[] stanzas = this.getStanzas();
        int nStanzas = stanzas == null ? 0 : stanzas.length;
        boolean defaultCPOK = false;
        if (nStanzas > 0) {
            if (cpName != null && cpName.length() > 0) {
                for (int i = 0; i < nStanzas && !defaultCPOK; ++i) {
                    if (!cpName.equals(stanzas[i])) continue;
                    defaultCPOK = true;
                }
            }
            if (!defaultCPOK) {
                cpName = this.getNonEmptyStanza(stanzas);
                this.duplicateStanza(cpName, null);
                this.adjustProperties();
                return cpName;
            }
        }
        if (defaultCPOK) {
            return cpName;
        }
        return null;
    }

    public synchronized VWSession getVWSession(String cpName) throws VWException {
        String m_method = "getVWSession";
        this.refresh();
        if (cpName == null || cpName.length() == 0) {
            cpName = this.getStanzaProperty("cm.router", false);
        }
        if (cpName == null) {
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.MissingCPForWS", "There is no connection point configured for P8BPMWSBroker servlet to use.  Please use the Process Task Manager to configure a connection point.");
        }
        String userName = this.getUserName();
        String password = this.getPassword();
        if (userName == null || userName.length() == 0 || password == null || password.length() == 0) {
            throw new VWException("filenet.ws.listener.utils.WSListenerProperties.MissingCreds", "There is no credentials configured for P8BPMWSBroker servlet to use.  Please use the Process Task Manager to configure a connection point.");
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "getVWSession", userName + "," + cpName + ", from " + this.m_fullPath);
        }
        return VWSessionManager.getVWSession(userName, password, cpName, this.getProperty("filenet.pe.bootstrap.ceuri"));
    }

    public String getUserName() throws VWException {
        this.adjustCreds();
        return this.m_name;
    }

    private void adjustCreds() throws VWException {
        block6: {
            String m_method = "adjustCreds";
            this.refresh();
            this.m_pw = this.getStanzaProperty("cm.uid", false);
            this.m_name = this.getStanzaProperty("cm.name", false);
            if (this.m_pw != null && this.m_name != null && this.m_name.equals("-1")) {
                try {
                    VWCMConvertTwo converter = new VWCMConvertTwo(0);
                    VWAuthItem item = converter.getDString(this.m_pw);
                    if (item != null) {
                        this.m_name = item.getName();
                        this.m_pw = item.getPassword();
                        if (this.m_pw != null && this.m_pw.compareTo("\"\"") == 0) {
                            this.m_pw = "";
                        }
                        break block6;
                    }
                    WSListenerProperties.errMsg("PW = " + this.m_pw + ", name=" + this.m_name);
                    VWException vwe = new VWException("vw.integrator.base.VWCMInvalidUserNamePassword", "User name or password is invalid.");
                    logger.throwing(m_className, "adjustCreds", vwe);
                    throw vwe;
                }
                catch (VWException vwex) {
                    throw vwex;
                }
                catch (Exception e) {
                    logger.throwing(m_className, "adjustCreds", e);
                    throw new VWException(e);
                }
            }
        }
    }

    public String getPassword() throws VWException {
        this.adjustCreds();
        return this.m_pw;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Properties readFromFile() throws VWException {
        block16: {
            block15: {
                m_method = "readFromFile";
                randomInstream = null;
                try {
                    try {
                        newModifiedDate = this.m_File.lastModified();
                        if (newModifiedDate <= this.lastModified) {
                            var5_5 = null;
                            var13_7 = null;
                            if (randomInstream == null) return var5_5;
                            break block15;
                        }
                        this.lastModified = newModifiedDate;
                        randomInstream = new RandomAccessFile(this.m_File, "r");
                        lastFileSize = randomInstream.length();
                        bArr = new byte[(int)lastFileSize];
                        retryIt = new RetryManager(WSListenerProperties.LOCK_TIMEOUT);
                        props = new Properties();
                        while (true) {
                            try {
                                randomInstream.read(bArr);
                                bInStream = new ByteArrayInputStream(bArr);
                                props.load(bInStream);
                                if (!WSListenerProperties.validateRouterPath(props, "readFromFile")) {
                                    props.setProperty("router.path", this.m_routerPath);
                                    WSListenerProperties.validateRouterPath(props, "readFromFileAGAIN");
                                }
                                var11_19 = props;
                                break block16;
                            }
                            catch (Throwable t) {
                                if (!(t instanceof IOException) || t.getMessage().indexOf("lock") != -1) {
                                    // empty if block
                                }
                                retryIt.setCauseObj(t);
                                if (retryIt.again()) continue;
                                cause = retryIt.getCauseObj();
                                if (cause instanceof Throwable == false) throw new VWException("filenet.ws.listener.utils.WSListenerProperties.readTimeout", "Read timeout for P8BPMWSBroker.properties file.  Error={0}", retryIt.toString());
                                throw new VWException((Throwable)cause);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        WSListenerProperties.logger.throwing("WSListenerProperties", "readFromFile", e);
                        throw new VWException(e);
                    }
                }
                catch (Throwable var12_20) {
                    var13_9 = null;
                    if (randomInstream == null) throw var12_20;
                    try {
                        randomInstream.close();
                        randomInstream = null;
                        throw var12_20;
                    }
                    catch (Exception e) {
                        throw var12_20;
                    }
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 274->283)] { 
lbl54:
            // 1 sources

            randomInstream.close();
            return var5_5;
lbl56:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return var5_5;
        }
        var13_8 = null;
        if (randomInstream == null) return var11_19;
        try {}
        catch (Exception e) {
            // empty catch block
            return var11_19;
        }
        randomInstream.close();
        return var11_19;
    }

    public static WSListenerProperties instance(PathUtils searchPath) throws Exception {
        return WSListenerProperties.instance(searchPath, null);
    }

    public static WSListenerProperties instance(PathUtils searchPath, String cpName) throws VWException {
        String routerFullPath = WSListenerProperties.getPath(searchPath, true);
        return WSListenerProperties.instanceFromFileName(routerFullPath, cpName);
    }

    public static WSListenerProperties instanceFromFileName(String fullPath, String cpName) throws VWException {
        return new WSListenerProperties(fullPath, cpName);
    }

    public String getFullPath() {
        return this.m_fullPath;
    }

    private String[] getStanzaKeysForAPrefix(String prefix) {
        Enumeration<Object> e = this.keys();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            v.add(key);
        }
        return v.toArray(new String[0]);
    }

    public String[] getStanzasForListenerBaseURL(String baseURL) {
        String[] keys = this.getStanzaKeysForAPrefix("listener.base.url");
        int nKeys = keys == null ? 0 : keys.length;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < nKeys; ++i) {
            String value = super.getProperty(keys[i]);
            if (value == null || !value.equals(baseURL)) continue;
            v.add(keys[i]);
        }
        return v.toArray(new String[0]);
    }

    public String getRealBaseURL() {
        String[] names = new String[]{"listener.base.url", "listener.local.host"};
        String[] values = this.getProperties(names);
        String baseURL = values[0];
        String listenerLocalHost = values[1];
        if (listenerLocalHost == null) {
            return baseURL;
        }
        String m_method = "getRealBaseURL:" + baseURL + ":" + listenerLocalHost;
        try {
            URL url = new URL(baseURL);
            StringBuffer buf = new StringBuffer();
            buf.append(url.getProtocol()).append("://").append(listenerLocalHost).append(url.getPath());
            String query = url.getQuery();
            if (query != null) {
                buf.append("?").append(query);
            }
            String newBaseURL = buf.toString();
            try {
                url = new URL(newBaseURL);
                return newBaseURL;
            }
            catch (MalformedURLException e) {
                logger.severe(m_className, m_method, newBaseURL + " is not valid!");
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return baseURL;
    }

    public String toString() {
        return "WSListenerProperties:" + this.m_fullPath + super.toString();
    }

    private String[] getStanzas() {
        String[] keys = this.getStanzaKeysForAPrefix("cm.router");
        int nKeys = keys == null ? 0 : keys.length;
        for (int i = 0; i < nKeys; ++i) {
            keys[i] = keys[i].substring("cm.router".length());
            if (keys[i].length() <= 0 || keys[i].charAt(0) != '.') continue;
            keys[i] = keys[i].substring(1);
        }
        return keys;
    }

    private Properties getNonStanzaProperties() {
        try {
            this.refresh();
        }
        catch (Throwable t) {
            // empty catch block
        }
        String[] stanzas = this.getStanzas();
        int nStanzas = stanzas == null ? 0 : stanzas.length;
        Properties props = new Properties();
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            boolean addIt = true;
            for (int i = 0; i < nStanzas && addIt; ++i) {
                if (stanzas[i] == null || stanzas[i].trim().length() == 0 || !key.endsWith(stanzas[i])) continue;
                addIt = false;
            }
            if (!addIt) continue;
            props.put(key, super.get(key));
        }
        return props;
    }

    private static void ppProperties(Properties p, StringBuffer b) {
        if (b == null || p == null) {
            return;
        }
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(p);
        for (String string : t.keySet()) {
            b.append(string).append("=");
            String value = p.getProperty(string);
            for (int j = 0; j < value.length(); ++j) {
                char c = value.charAt(j);
                switch (c) {
                    case ':': 
                    case '=': 
                    case '\\': {
                        b.append('\\');
                    }
                }
                b.append(c);
            }
            b.append("\n");
        }
    }

    private static String getPPProperties(Properties p) {
        StringBuffer b = new StringBuffer();
        WSListenerProperties.ppProperties(p, b);
        return b.toString();
    }

    private Properties getStanzaProperties(String stanza) {
        if (stanza == null || stanza.trim().length() == 0) {
            return this.getNonStanzaProperties();
        }
        try {
            this.refresh();
        }
        catch (Throwable t) {
            // empty catch block
        }
        Properties props = new Properties();
        Enumeration<Object> e = this.keys();
        stanza = "." + stanza;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.endsWith(stanza)) continue;
            props.put(key, super.get(key));
        }
        return props;
    }

    public String getDynamicClientListenerPort() {
        String m_method = "getDynamicClientListenerPort";
        String portStr = this.getProperty("filenet.wsrm.client.listener.port");
        if (portStr != null && !"0".equals(portStr)) {
            return portStr;
        }
        return "32767";
    }

    private String wsrmSandeshaPropertiesFile() throws VWException {
        String m_method = "WSRMSandeshaPropertiesFile";
        String stanza = this.getStanza();
        String port = this.getDynamicClientListenerPort();
        if (logger.isFinest()) {
            logger.finest(m_className, "WSRMSandeshaPropertiesFile", stanza + "=" + port);
        }
        return MessageFormat.format(WSRM_SANDESHA_PROPERTIES_CONTENTS_TEMPLATE, stanza, port);
    }

    private String wsrmPolicyXMLFile() throws VWException {
        String m_method = "WSRMPolicyXMLFile";
        String[] values = this.getProperties(WSRMPropertyNames);
        return MessageFormat.format(WSRM_WSRMPOLICY_XML_CONTENTS_TEMPLATE, this.getStanza(), values[1], values[2], values[3]);
    }

    public void WSRMSetProperties(String clientListenerPort, String inactivityTimeout, String baseRetransmissionInterval, String acknowledgementInterval) throws VWException {
        String[] values = new String[]{clientListenerPort, inactivityTimeout, baseRetransmissionInterval, acknowledgementInterval};
        this.setProperties(WSRMPropertyNames, values, true);
    }

    public void WSRMSandeshaSettings() {
        String s;
        Method m;
        String m_method = "WSRMSandeshaSettings";
        try {
            Class<?> PolicyLoaderCls = Class.forName("org.apache.sandesha.util.PolicyLoader");
            m = PolicyLoaderCls.getMethod("setResourceString", String.class);
            s = this.wsrmPolicyXMLFile();
            m.invoke(null, s);
        }
        catch (Throwable t) {
            logger.throwing(m_className, "WSRMSandeshaSettings", t);
        }
        try {
            Class<?> PropertyLoaderCls = Class.forName("org.apache.sandesha.util.PropertyLoader");
            m = PropertyLoaderCls.getMethod("setResourceString", String.class);
            s = this.wsrmSandeshaPropertiesFile();
            m.invoke(null, s);
        }
        catch (Throwable t) {
            logger.throwing(m_className, "WSRMSandeshaSettings", t);
        }
    }

    private static String blankPw(String pw) {
        if (pw == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        char[] pwArr = pw.toCharArray();
        buf.append(pwArr[0]);
        int pwArrLen = pwArr.length;
        for (int i = 1; i < pwArrLen; ++i) {
            buf.append("*");
        }
        return buf.toString();
    }

    public String printMe() {
        StringBuffer buf = new StringBuffer();
        String[] stanzas = this.getStanzas();
        int nStanzas = stanzas == null ? 0 : stanzas.length;
        for (int i = 0; i < nStanzas; ++i) {
            String name = stanzas[i] == null || stanzas[i].trim().length() == 0 ? "DEFAULT" : stanzas[i];
            buf.append("\n---------- ").append(name).append("------------\n");
            WSListenerProperties.ppProperties(this.getStanzaProperties(stanzas[i]), buf);
        }
        try {
            buf.append("\nUsername=").append(this.getUserName());
        }
        catch (Exception e) {
            buf.append("\nUnable to get user name..").append(e);
        }
        try {
            buf.append("\nPassword=").append(WSListenerProperties.blankPw(this.getPassword()));
        }
        catch (Exception e) {
            buf.append("\nUnable to get password..").append(e);
        }
        return buf.toString();
    }

    private static void printUsage() {
        System.out.println("options: /noverbose /file <propertyFile to display>\r\n\t/fixupDefault -- fixup the default stanza\r\n\t/cp cpName\r\n\t/test /nThreads # /nIterations #\r\n\t/duplicate /sourceCP cp [/destCP cp]\r\n\t/remove /cp cpName");
        System.exit(1);
    }

    private static void errMsg(String s) {
        System.err.println("Thread: " + Thread.currentThread().getName() + ":" + s);
    }

    private static void msg(String s) {
        if (verbose) {
            System.out.println("Thread: " + Thread.currentThread().getName() + ":" + s);
        }
    }

    private static void testProps() {
        try {
            WSListenerProperties props = WSListenerProperties.instance(null, null);
            WSListenerProperties.msg(props.getFullPath());
            String[] names = new String[]{"prop1", "prop2"};
            String[] values = new String[]{"03/14/2009 " + Thread.currentThread().getName(), "1002"};
            WSListenerProperties.msg("Setting " + names[0] + "=" + values[0]);
            props.setProperties(names, values, false);
            WSListenerProperties.msg(names[0] + "=" + props.getProperty(names[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h")) {
                WSListenerProperties.printUsage();
            }
            verbose = !c.isPresent("noverbose");
            WSListenerProperties props = null;
            String theFile = c.getParameter("file");
            String cpName = c.getParameter("cp");
            props = theFile != null ? WSListenerProperties.instanceFromFileName(theFile, cpName) : WSListenerProperties.instance(null, null);
            props.refresh();
            WSListenerProperties.msg("INITIAL ---- ");
            WSListenerProperties.msg(props.printMe());
            if (c.isPresent("fixupDefault")) {
                String oldDefaultCP = props.getPropertyNoStanza("cm.router", null);
                String newDefaultCP = props.checkDefaultCPName(oldDefaultCP);
                WSListenerProperties.msg("-- Fixup default, Old=" + oldDefaultCP + ", New=" + newDefaultCP);
            } else if (c.isPresent("duplicate")) {
                props.duplicateStanza(c.getParameter("sourceCP"), c.getParameter("destCP"));
            } else if (c.isPresent("remove")) {
                props.cleanupStanza(c.getParameter("cp"));
            } else if (c.isPresent("test")) {
                int nThreads = c.getIntParameter("nThreads", 5);
                int nIteration = c.getIntParameter("nIterations", 5);
                for (int j = 0; j < nIteration; ++j) {
                    int i;
                    Thread[] workers = new Thread[nThreads];
                    for (i = 0; i < nThreads; ++i) {
                        Thread t;
                        workers[i] = t = new Thread(new Runnable(){

                            public void run() {
                                WSListenerProperties.testProps();
                            }
                        });
                        t.setName("T" + i);
                        t.start();
                        Thread.sleep(1000L);
                    }
                    for (i = 0; i < nThreads; ++i) {
                        props.refresh();
                        WSListenerProperties.msg("While waiting for threads " + i + "--" + props.printMe());
                        workers[i].join();
                    }
                }
            }
            props.refresh();
            WSListenerProperties.msg("AT THE END. --- ");
            WSListenerProperties.msg(props.printMe());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static String getLocalListenerHost(String listenerURL) {
        int i2;
        int i1 = listenerURL.indexOf("//");
        if (i1 != -1 && (i2 = listenerURL.indexOf("/", i1 += 2)) != -1) {
            return listenerURL.substring(i1, i2);
        }
        return null;
    }

    static {
        try {
            String sLockTimeOut = WSListenerProperties.getPrivilegedSystemProperty("filenet.pe.p8bpmwsbroker.read.timeout");
            if (sLockTimeOut != null) {
                LOCK_TIMEOUT = Integer.parseInt(sLockTimeOut);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        JSSEPropertyNames = new String[]{"cm.keystore", "cm.keystore.uid", "cm.truststore", "cm.truststore.uid", "cm.certificates.autoaccept"};
        WSLoggerFileName = null;
        try {
            WSLoggerFileName = new File(WSLogger.DEFAULT_FILENAME).getAbsolutePath();
        }
        catch (Exception e) {
            WSLoggerFileName = WSLogger.DEFAULT_FILENAME;
        }
        dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        WSRM_WSRMPOLICY_XML_CONTENTS_TEMPLATE = "<!-- WSRMPolicy.xml for {0} -->\n<wsdl:definitions\ntargetNamespace=\"urn:sandesha.policy\"\nxmlns:tns=\"example.com\"\nxmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\nxmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"\nxmlns:wsrm=\"http://schemas.xmlsoap.org/ws/2005/02/rm/policy\"\nxmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\">\n    <wsp:UsingPolicy wsdl:required=\"true\"/>\n    <wsp:Policy wsu:Id=\"MyPolicy\">\n        <wsrm:RMAssertion>\n            <wsrm:InactivityTimeout Milliseconds=\"{1}\"/>\n            <wsrm:BaseRetransmissionInterval Milliseconds=\"{2}\"/>\n            <wsrm:ExponentialBackoff/>\n            <wsrm:AcknowledgementInterval Milliseconds=\"{3}\"/>\n        </wsrm:RMAssertion>\n        <!-- omitted assertions -->\n    </wsp:Policy>\n    <!-- omitted elements -->\n    <wsdl:binding name=\"MyBinding\" type=\"tns:MyPortType\">\n        <wsp:PolicyReference URI=\"#MyPolicy\"/>\n        <!-- omitted elements -->\n    </wsdl:binding>\n</wsdl:definitions>   \n";
        WSRM_SANDESHA_PROPERTIES_CONTENTS_TEMPLATE = "# Sandesha.properties for {0}.\n# This is the port in which client side listener listens.\nCLIENT_LISTENER_PORT = {1}\n\n# This is the SimpleAxisServerImpl running port. Only for testing purposes.\nSIMPLE_AXIS_SERVER_PORT = 8080\n\n# Any number of handlers can be included as shown below for the response path of the Sender.\nresponseHandler1 = filenet.ws.listener.axis.rm.AddressingHandler\nresponseHandler2 = org.apache.sandesha.ws.rm.handlers.RMServerRequestHandler\n\n# If there are additional handlers that needs to be included in the Senders request path\n# then use the following configuration.\n# requestHandler1 = package.name.DummyHandler\n\n# These are the handlers for the Listener's request path. Listener's request path is used to\n# retrieve asynchronous responses and other RM protocol messages and hence the handlers we put here\n# should be the RESPONSE handlers with respect to normal invocation.\nlistenerRequestHandler1 = filenet.ws.listener.axis.rm.AddressingHandler\nlistenerRequestHandler2 = org.apache.sandesha.ws.rm.handlers.RMServerRequestHandler\n\n# Define the strategy for executing web service invokes.\n# This impl uses the apache axis thread pool and configures\n# it to the given size.\ninvokeStrategy=org.apache.sandesha.server.ThreadPoolInvokeStrategy:threadPoolSize=10\n\n# Define the invoke handler that will execute the web service invokes.\n# This impl simply delegates to the handler specified by the \"invoker\" param.\n# invokeHandler=org.apache.sandesha.server.DelegateInvokeHandler:invoker=org.apache.axis.providers.java.MsgProvider\ninvokeHandler=filenet.ws.listener.axis.rm.WSDelegateInvokeHandler:invoker=filenet.ws.listener.axis.rm.WSRMMsgProvider\n";
        WSRMPropertyNames = new String[]{"filenet.wsrm.client.listener.port", "filenet.wsrm.inactivity.timeout", "filenet.wsrm.base.retransmission.interval", "filenet.wsrm.acknowledgement.interval"};
        verbose = false;
    }

    final class VWCMConvertTwo
    extends VWConvertTwo {
        int KEY_MASK = 0;

        protected VWCMConvertTwo(int mask) {
            this.KEY_MASK = mask;
        }

        protected String getKey(int id) {
            return "MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc";
        }

        protected String getEString(String name, String password) throws Exception {
            return super.getEString(name, password);
        }

        protected VWAuthItem getDString(String token) throws Exception {
            return super.getDString(token);
        }
    }
}

